#version 330
#extension GL_EXT_gpu_shader4 : enable
//OJ - Fibber 28 scene 2Mod01.fsh by rammoskar
//
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


float sphere(vec3 p, float r)
{
	return length(p) - r;
}

float udBox( vec3 p, vec3 b )
{
  return length(max(abs(p)-b,0.0));
}

float sdBox( vec3 p, vec3 b )
{
  vec3 d = abs(p) - b;
  return min(max(d.x,max(d.y,d.z)),0.0) +
         length(max(d,0.0));
}


float sdTorus( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length(q)-t.y;
}

float sdCylinder( vec3 p, vec3 c )
{
  return length(p.xz-c.xy)-c.z;
}



float udRoundBox( vec3 p, vec3 b, float r )
{
  return length(max(abs(p)-b,0.0))-r;
}

float length6( vec2 p )
{
	p = p*p*p; p = p*p;
	return pow( p.x + p.y, 1.0/6.0 );
}

float length8( vec2 p )
{
	p = p*p; p = p*p; p = p*p;
	return pow( p.x + p.y, 1.0/8.0 );
}

float sdTorus88( vec3 p, vec2 t )
{
  vec2 q = vec2(length8(p.xz)-t.x,p.y);
  return length8(q)-t.y;
}

float sdTorus62( vec3 p, vec2 t )
{
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return length6(q)-t.y;
}

// polynomial smooth min (k = 0.1);
float smin( float a, float b) //, float k )
{
	float k = 0.1;
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}

float smink( float a, float b, float k )
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}


float sdCapsule( vec3 p, vec3 a, vec3 b, float r )
{
    vec3 pa = p - a, ba = b - a;
    float h = clamp( dot(pa,ba)/dot(ba,ba), 0.0, 1.0 );
    return length( pa - ba*h ) - r;
}



float sdHexPrism( vec3 p, vec2 h )
{
    vec3 q = abs(p);
    return max(q.z-h.y,max((q.x*0.866025+q.y*0.5),q.y)-h.x);
}



//uniform float tick;
//uniform sampler2D noiseP;
//uniform vec2 windowSize;

#define MAT_BLOCK 1.0
#define MAT_LIGHT 2.0
#define MAT_SPHERE 3.0
#define MAT_WATER 4.0
#define MAT_S2_OBJECT 5.0
#define MAT_DRILL 6.0
#define MAT_S3_BLOCK 7.0
#define MAT_BALL 8.0
#define MAT_S2_BLOCK 9.0
#define MAT_S4_FLOOR 10.0
#define MAT_S4_MIRROR 11.0
#define MAT_S1_TORUS 12.0
#define MAT_S5_BLOB 13.0
#define MAT_S5_FLOOR 14.0
#define MAT_S5_PILLAR 15.0
#define MAT_MORPH 16.0
#define MAT_S6_ROOF 17.0
#define MAT_S2_WATER 18.0
#define MAT_S6_WATER 19.0
#define MAT_TEXT 20.0
#define MAT_TEXT2 21.0

#define EPS 0.01

#define SCENE_0 20
#define SCENE_1 50
#define SCENE_2 80
#define SCENE_3 110
#define SCENE_4 140
#define SCENE_5 170
#define SCENE_6 200
#define SCENE_7 210

vec2 un(vec2 a, vec2 b)
{
	return a.x < b.x ? a : b;
}

vec2 sun(vec2 a, vec2 b)
{
	float sm = smin(a.x,b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);
	
	return ca < cb ? vec2(sm, a.y) : vec2(sm, b.y);
}

vec2 sunk(vec2 a, vec2 b, float k)
{
	float sm = smink(a.x,b.x, k);
	float m = min(a.x, b.x);
	float ca = abs(sm -a.x);
	float cb = abs(sm -b.x);
	
	return ca < cb ? vec2(sm, a.y) : vec2(m, b.y);
}


vec2 unn(vec2 a, float dis, float mat)
{
	return a.x < dis ? a : vec2(dis, mat);
}



mat3 rot(float x, float y, float z)
{
	float cx = cos(x);
	float sx = sin(x);
	float cy = cos(y);
	float sy = sin(y);
	float cz = cos(z);
	float sz = sin(z);
	mat3 xm = mat3(1, 0, 0,
					0, cx, -sx,
					0, sx, cx);
	mat3 ym = mat3(cy, 0, sy,
			  		0, 1, 0,
			  		-sy, 0, cy);
	mat3 zm = mat3(cz, -sz, 0,
					sz, cz, 0,
					0, 0, 1);
	return xm * ym * zm; 
}









vec2 water_2(vec3 p, vec3 rd)
{
	float t = iTime - float(SCENE_1);
	if(rd.y > 0.0){
		return vec2(999999, MAT_WATER);
	}
	
	float wdis = distance(p.xz, vec2(0, 6));
	float w = 0.0; 
	float d = 
		(sin(-t * 3.0 + 5.0 * wdis)) * w;// + 
		//TODO texture length(texture(noiseP, p.xz*0.5 + vec2(0, tick*0.1)))*0.1 + 
		//TODO texture length(texture(noiseP, p.xz*0.5 + vec2(tick*0.13, 0)))*0.1;
	d *= 0.1 * smoothstep(0.0, 5.0, t);

	float h = p.y - d * 0.1;
	
	float dis = (0.1 -p.y)/rd.y;

	return vec2(max(h, dis), MAT_S2_WATER);
}





bool inRefraction = false;


vec2 scene(vec3 p, vec3 rd)
{
	float t = mod(iTime,30.0);// - float(SCENE_1);
	vec3 s = vec3(1);
	vec3 q = mod(p, s) - 0.5 * s;
	ivec3 n = ivec3(floor(p / s));
	
					
	float mt = 10.0;
	float siz = 1.5 + 0.5 * sin(t * 0.3);
	vec3 pm = p - vec3(0, 0.5 + sin(t) * 0.1 * t, 0);
	float a = sphere(pm * rot(t * 0.8, t * 0.5, t * 1.4), siz);
	float b = sdTorus(pm * rot(t * 0.8, t * 0.5, t * 1.4), vec2(siz, siz * 0.4));
	float c = sdTorus88(pm * rot(t * 0.8, t * 0.5, t * 1.4), vec2(siz, siz * 0.4));
	
	float t1 = smoothstep(mt*0.0, mt*1.0, t);
	float t2 = smoothstep(mt*1.0, mt*2.0, t); 
	float t3 = smoothstep(mt*2.0, mt*3.0, t);
	
	float mdis = a*(1.0-t1) + b*t1*(1.0-t2) + c*t2; 
	
	vec2 res = sunk(water_2(p, rd),
					vec2(mdis, MAT_BALL),
					0.8);
	
	float roomDis = -sphere(vec3(n), 20.0);//-sdBox(n - vec3(0, 10, 0), vec3(50, 10, 50));
	if (roomDis < 0.0) {
		//res = un(res, vec2(udRoundBox(q, vec3(0.4), 0.1), MAT_S2_BLOCK));
		vec2 np = vec2(p.x + p.y * 0.5, p.y * 0.5 + p.z);
		res = un(res, vec2(sdHexPrism(q.xzy + + 0.04 * (0.5 - 0.5/*texture(noiseP, np).x*/), vec2(0.5, 0.5)), MAT_S2_BLOCK));
	} else {
		vec3 d = (s * 0.5 -  sign(rd)* q) / abs(rd);
		float b = min(d.x, min(d.y, d.z));
		float a = max(roomDis - 1.73, b + EPS); // TODO 1.73 kan vara for mycket 
		res = un(res, vec2(max(EPS, a), -1));
	}
	return res;
}


vec3 getNormal(vec3 p, vec3 rd, vec3 ro)
{
    vec3 normal;
    vec3 ep = vec3(0.01, 0, 0);
    normal.x = scene(p + ep.xyz, rd).x - scene(p - ep.xyz, rd).x;
    normal.y = scene(p + ep.yxz, rd).x - scene(p - ep.yxz, rd).x;
    normal.z = scene(p + ep.yzx, rd).x - scene(p - ep.yzx, rd).x;
    return normalize(normal);
}


float specular(vec3 normal, vec3 light, vec3 viewdir, float s)
{
	float nrm = (s + 8.0) / (3.1415 * 8.0);
	float k = max(0.0, dot(viewdir, reflect(light, normal)));
    return  pow(k, s);
}

mat4 rotationMatrix(vec3 axis, float angle)
{
    axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat4(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s,  0.0,
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s,  0.0,
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c,           0.0,
                0.0,                                0.0,                                0.0,                                1.0);
}

float shadow(in vec3 ro, in vec3 rd, float mint, float maxt, float shadowAmbient)
{
    for( float t=mint; t < maxt; )
    {
        float h = scene(ro + rd*t, rd).x;
        if( h<0.01 )
            return shadowAmbient;
        t += h;
    }
    return 1.0;
}


float softshadow( in vec3 ro, in vec3 rd, in float mint, in float maxt )
{
	float res = 1.0;
    float t = mint;
   for( float t=mint; t < maxt; )
    {
		vec2 res = scene( ro + rd*t, rd );
		float h = res.x;
		float m = res.y;
		if (m  > 0.0) {
       	 res = min( res, h );
		}
		t += h;
        if( h<0.01 || t>maxt ) break;
    }
    return clamp( res, 0.0, 1.0 );

}

/*vec3 applyFog(vec3 rgb, float dis, vec3 rayDir, vec3 sunDir, vec3 p)
{
	float fogAmount = 1.0 - exp(-dis*0.005);
	float sunAmount = 0; //max(0.0, dot(rayDir, sunDir));
	vec3 fogColor = mix(vec3(0.3), vec3(1.0,0.9,0.7), pow(sunAmount,12.0));
	return mix(rgb, fogColor, fogAmount);
}*/
#define jumps 4
#define imax 600
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
	vec3 eye = vec3(0);
	vec3 light = vec3(0);
	vec3 tar = vec3(0);
	bool waterRefract = false;
	float lightInvSize = 0.5;
	float shadowAmbient = 0.3;
	float lightIntensity = 0.004;
	bool lightCollision = false;
	float refJumpDistance = 0.02;
	bool shadows = true;
	float tmax = 800.0;
	vec3 skyColor = vec3(0);
	bool cubicDis = false;
	vec3 rollV = vec3(0, 1, 0);
    
	float time = iTime - float(SCENE_1);
    time *= 0.2;
    float r = 6.0 + 2.0 * sin(time * 0.1);
    eye = vec3(cos(time * 0.5) * r, 2, sin(time * 0.5) * r);
    tar = vec3(0, 1, 0);
    light = vec3(-10, 5, -10);
    lightIntensity = 0.001;
    lightCollision = true;
    refJumpDistance = 0.1;
    shadowAmbient = 0.4;
    shadows = false;
	vec3 dir = normalize(tar - eye);
	vec3 right = normalize(cross(rollV, dir)); 
 	vec3 up = cross(dir, right);
    
    float u = (gl_FragCoord.x / iResolution.x) * 2.0 - 1.0;
    float v = ((gl_FragCoord.y / iResolution.y) * 2.0 - 1.0) * (iResolution.y/iResolution.x); 

    vec3 color = skyColor;
      
    float t = 0.0;
	vec3 ro = eye;
	vec3 rd = normalize(dir + right*u + up*v);
	
	float ref = 1.0;
	float lightAura = 0.0;
    float breakVar = 0.0;
	for(int j = 0; j < jumps; ++j)
    {
        if (breakVar > 0.5) {
            break;
        }
    	t = 0.0;
    	 for(int i = 0; i < imax; ++i)
   		 {
             if (t >= tmax) {
             	break;
             }
	        vec3 p = ro + rd * t;
	        vec2 dm = scene(p, rd);
	        float d = dm.x;
	        float m = dm.y;
			
			
	        if(d < EPS || i == imax || t >= tmax) 
	        {
	        	vec3 x0 = light;
	        	vec3 x1 = ro;
	        	vec3 x2 = ro + rd;
	        	float ldis = pow(length(cross(x2 - x1, x1 - x0)),2.0) / pow( distance(x2, x1), 2.0); 
	        	vec3 normal = getNormal(p, rd, ro);
				
				vec3 invLight = normalize(light - p);
	        	float diffuse = max(0.,dot(invLight, normal));
	        	vec3 refrd = reflect(rd, normal);
	        	

	        	vec3 n = floor(p);
				vec3 c = vec3(0.5);
				
				if(m == MAT_BLOCK){
					c = vec3(sin(n.y) * 0.1 + 0.3, sin(n.y) * 0.1 +0.1, sin(n.y) * 0.1 + 0.1)*1.1;
				}
				else if(m == MAT_SPHERE){
					c = vec3(0, 0.5, 0);
				}
				else if(m == MAT_WATER){
	        		c = vec3(1); 
				}
				else if (m == MAT_S2_OBJECT) {
					c = vec3(1, 0, 0);
				} else if (m == MAT_DRILL) {
					
				} else  if (m == MAT_S3_BLOCK) {
					/*if (n.z == 16) {
						c = sin(2*distance(vec2(n.xy), vec2(0, 0)) ) > 0 ? vec3(0.1, 0.2, 0.6) : vec3(0.01, 0.01, 0.01);
					} else {
						c = vec3(0.1, 0.2, 0.6);
					}*/
					c = vec3(sin(n.x)*0.5 + 0.5, sin(n.y)*0.5 + 0.5, sin(n.z)*0.5 + 0.5);
				} else if (m == MAT_BALL) {
					c = vec3(0.5);
				} else if (m == MAT_S2_BLOCK) {
					int t = int(iTime - float(SCENE_1));
					c = vec3(n.y * 0.05, n.y * 0.08, n.y * 0.03);//vec3(sin(n) * 0.1);
					//if (int(n.y) % 6 == t % 6) {
					//	c.r = 1;
					//}
					clamp(c, 0.0, 1.0);
				} else if (m == MAT_S4_FLOOR) {
					
				} else if (m == MAT_S4_MIRROR) {
					c = vec3(1);
				} else if (m == MAT_S1_TORUS) {
					
				} else if (m == MAT_S5_BLOB) {
					c = vec3(1);
				} else if (m == MAT_S5_FLOOR) {
					c = vec3(0.9);
				} else if (m == MAT_S5_PILLAR) {
					c = vec3(0.8, 0, 0);
				} else if (m == MAT_MORPH) {
					vec3 pc = p + vec3(90);
	        		vec3 matCol = vec3(pc.x/10.0, (pc.x + pc.z) / 5.0, pc.z/8.0);
	        		c = (sin(matCol) + 1.0) * 0.5;
				} else if (m == MAT_S6_ROOF) {
					c = vec3(0, 0, 1);
				} else if (m == MAT_S2_WATER) {
					c = vec3(0.3, 0.3, 0.6);
				} else if (m == MAT_S6_WATER) {
					c = vec3(0.6, 0.6, 1.0);
				} else if (m == MAT_TEXT) {
					c = vec3(1, 0, 0);
				}
				
	        	if (inRefraction) {
					
	        	} else {
					c = 0.7*c* (1.0 + diffuse);
					if(shadows && m != MAT_S5_BLOB){
						
					}
		        	c += specular(normal, -invLight, normalize(eye - p), 70.0);
	        	}
	            
	            float dis = length(light - p);
	            float disFact = 1.0 / (1.0 + lightIntensity*dis*dis * (cubicDis ? dis : 1.0 ));
	            c *= disFact;
				
					        	
	        	float tl = -dot(x1 - x0, x2 - x1)/pow(distance(x2,x1),2.0);
	        	if(tl > 0.0 && ((lightCollision && distance(eye, light) < distance(eye, p)) || !lightCollision)){
	        		lightAura = max(lightAura, 1.0/(0.01 + lightInvSize*ldis));
	        	}
				//color = applyFog(color, distance(eye, p), rd, vec3(0, 0, 1), p);

				color = mix(color, c, ref);
				
				if(m == MAT_WATER || m == MAT_S2_WATER || m == MAT_S6_WATER){
					if (waterRefract) {
						rd = refract(rd, normal, 1.0/1.333); 
						ro = p + rd*0.02;
						inRefraction = true;
					} else {
						rd = reflect(rd, normal);
						ro = p + rd*0.02;
					}
				} else {
					rd = reflect(rd, normal);
	         		//ro = p + rd*0.02;
	         		ro = p + rd*refJumpDistance;
				}

				
	            if(m == MAT_LIGHT){
	            	color = vec3(0.5, 0.5, 0.5);
	            }

	        	
	        	if (m == MAT_WATER) {
	        		//inRefraction = true;
	        		ref = 0.8;
	        	} else if (m == MAT_S6_WATER) {
					ref *= 0.8;
	        	} else if (m == MAT_S5_BLOB) {
	        		ref = 0.7;
	        	} else if (m == MAT_S4_MIRROR) {
	        		ref = 0.9;
        		} else if (m == MAT_BALL) {
					ref *= 0.4;
	       		} else if (m == MAT_S2_WATER) {
					ref *= 0.5;
	       		} else if (m == MAT_MORPH) {
	        		ref *= 0.4;
	        	} else {
		        	ref = 0.0;
	        	}
	        	if (ref <= 0.01) {
	        		//j = 10000;
					breakVar = 1.0;	        		
	        	}
	           	break;
	        }
	
	        t += d;
    	}
    }
    
   
    gl_FragColor = vec4(color + vec3(lightAura),  1.0); 
}
